import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {ServiceSubscriptionPermission} from '@components/ServiceSubscripionPermission/ServiceSubscriptionPermission';
import {toggleServiceSubscriptionPermission} from '@blocks/actions/form';

function mapStateToProps(state = {}) {
    const {form: {keepUnsubscribedShown, keepUnsubscribedValue} = {}, customs: {isWhiteLabel = false} = {}} = state;

    return {
        isWhiteLabel,
        keepUnsubscribedValue,
        isShown: hasExp(state, 'passport-subs-eula-check-on') || keepUnsubscribedShown
    };
}

const mapDispatchToProps = {
    toggleServiceSubscriptionPermission
};

const ConnectedServiceSubscriptionPermission = connect(
    mapStateToProps,
    mapDispatchToProps
)(ServiceSubscriptionPermission);

export {ConnectedServiceSubscriptionPermission as ServiceSubscriptionPermission};
