import React from 'react';
import PropTypes from 'prop-types';
import {classNames} from '@blocks/utils';

const b = classNames('SocialButton');
const SOCIAL_NAMES = {
    vk: i18n('_AUTH_.vkontakte'),
    fb: i18n('_AUTH_.facebook')
};

class SocialButton extends React.PureComponent {
    render() {
        const {name, onClick} = this.props;

        return (
            <button type='button' className={b('', {[name]: !!name})} onClick={onClick}>
                <span className={b('name')}>{SOCIAL_NAMES[name]}</span>
            </button>
        );
    }
}

SocialButton.propTypes = {
    name: PropTypes.oneOf(['vk', 'fb']),
    onClick: PropTypes.func
};

export {SocialButton};
