import React from 'react';
import PropTypes from 'prop-types';

const SupportLink = ({blockClassName, contactUsURL, onClick}) => (
    <span
        className={blockClassName('help')}
        onClick={onClick}
        dangerouslySetInnerHTML={{
            __html: i18n('Frontend.contact_us').replace('%1', contactUsURL)
        }}
    />
);

SupportLink.propTypes = {
    blockClassName: PropTypes.func.isRequired,
    contactUsURL: PropTypes.string.isRequired,
    key: PropTypes.string,
    onClick: PropTypes.func
};

export {SupportLink};
