import React, {Component} from 'react';
import PropTypes from 'prop-types';

import {TextArea} from '@components/TextArea';
import {Button} from '@components/Button';

import {cn} from '@bem-react/classname';

const b = cn('Survey');

import './Survey.styl';
import {setCookie} from '@blocks/utils';

export class Survey extends Component {
    state = {
        textareaValue: '',
        rateValue: ''
    };

    onChange = ({target} = {}) => {
        this.setState({
            textareaValue: target.value
        });
    };

    handleRating = (event) => {
        this.setState({
            rateValue: event.target.value
        });
    };

    onSubmit = (event) => {
        const {rateValue, textareaValue} = this.state;
        const {closePopup, writeUserDataToStatbox} = this.props;

        if (event) {
            event.preventDefault();
        }

        closePopup();
        setCookie('user_feedback', 90);

        if (!rateValue && !textareaValue) {
            writeUserDataToStatbox({action: 'send_empty_feedback'});
            return;
        }

        writeUserDataToStatbox({rateValue, textareaValue, action: 'send_feedback'});
    };

    render() {
        return (
            <div className={b('content')}>
                <h4 className={b('title')}>{i18n('Profile2.profile.survey.title')}</h4>
                <form onSubmit={this.onSubmit}>
                    <div className={b('wrap')}>
                        <fieldset className={b('fieldset')}>
                            <div className={b('rating')} data-t='survey:rating'>
                                <input
                                    checked={this.state.rateValue === '5'}
                                    type='radio'
                                    id='rate5'
                                    name='rating'
                                    value='5'
                                    onChange={this.handleRating}
                                />
                                <label htmlFor='rate5' className={b('rate')}>
                                    <span>{i18n('Profile2.profile.survey.rating_excellent')}</span>
                                </label>

                                <input
                                    checked={this.state.rateValue === '4'}
                                    type='radio'
                                    id='rate4'
                                    name='rating'
                                    value='4'
                                    onChange={this.handleRating}
                                />
                                <label htmlFor='rate4' className={b('rate')}>
                                    <span>{i18n('Profile2.survey.rating_good')}</span>
                                </label>

                                <input
                                    checked={this.state.rateValue === '3'}
                                    type='radio'
                                    id='rate3'
                                    name='rating'
                                    value='3'
                                    onChange={this.handleRating}
                                />
                                <label htmlFor='rate3' className={b('rate')}>
                                    <span>{i18n('Profile2.survey.rating_normal')}</span>
                                </label>

                                <input
                                    checked={this.state.rateValue === '2'}
                                    type='radio'
                                    id='rate2'
                                    name='rating'
                                    value='2'
                                    onChange={this.handleRating}
                                />
                                <label htmlFor='rate2' className={b('rate')}>
                                    <span>{i18n('Profile2.survey.rating_bad')}</span>
                                </label>

                                <input
                                    checked={this.state.rateValue === '1'}
                                    type='radio'
                                    id='rate1'
                                    name='rating'
                                    value='1'
                                    onChange={this.handleRating}
                                />
                                <label htmlFor='rate1' className={b('rate')}>
                                    <span>{i18n('Profile2.survey.rating_awful')}</span>
                                </label>
                            </div>
                        </fieldset>
                        <fieldset className={b('userText')}>
                            <label
                                htmlFor='user-text'
                                className={b('userTextLabel')}
                                dangerouslySetInnerHTML={{__html: i18n('Profile2.profile.survey.textarea_label')}}
                            />

                            <TextArea
                                value={this.state.textarea}
                                onChange={this.onChange}
                                size='l'
                                width='max'
                                name='user_text'
                                maxLength={1000}
                                dataT='survey:textarea'
                            />
                        </fieldset>
                        <Button
                            text={i18n('Frontend.send')}
                            onClick={this.onSubmit}
                            width='max'
                            size='l'
                            type='submit'
                            dataT='survey:submit'
                        />
                    </div>
                </form>
            </div>
        );
    }
}

Survey.propTypes = {
    closePopup: PropTypes.func.isRequired,
    writeUserDataToStatbox: PropTypes.func.isRequired
};
