import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {Survey} from './Survey.jsx';
import {setCookie} from '@blocks/utils';

export class SurveyPopup extends Component {
    componentDidMount() {
        this.props.writeUserDataToStatbox({action: 'opened'});
    }

    handleClose = () => {
        setCookie('user_feedback', 90);
        this.props.writeUserDataToStatbox({action: 'closed'});
        this.closePopup();
    };

    closePopup = () => {
        this.props.setEditMode('');
    };

    render() {
        const {writeUserDataToStatbox, isVisible} = this.props;

        return (
            <Modal visible={isVisible} zIndexGroupLevel={-0.5} onCloserClick={this.handleClose} dataT='survey:modal'>
                <Survey closePopup={this.closePopup} writeUserDataToStatbox={writeUserDataToStatbox} />
            </Modal>
        );
    }
}

SurveyPopup.propTypes = {
    setEditMode: PropTypes.func.isRequired,
    writeUserDataToStatbox: PropTypes.func.isRequired,
    isVisible: PropTypes.bool
};
