import {connect} from 'react-redux';
import {SurveyPopup} from './SurveyPopup.jsx';

import {setEditMode} from '@blocks/common/actions';
import {writeUserDataToStatbox} from '@blocks/actions/surveyPopup';

const mapStateToProps = (state) => {
    const {common = {}} = state;
    const {edit} = common;

    return {
        isVisible: edit === 'SHOW_SURVEY'
    };
};

const mapDispatchToProps = {
    setEditMode,
    writeUserDataToStatbox
};

const ConnectedSurveyPopup = connect(mapStateToProps, mapDispatchToProps)(SurveyPopup);

export {ConnectedSurveyPopup as SurveyPopup};
