import React, {Component} from 'react';
import PropTypes from 'prop-types';

function showWithLeadZero(number) {
    return String(number).length < 2 ? `0${number}` : String(number);
}

function getTimerSeconds(leftTime) {
    if (0 > leftTime) {
        return 0;
    }

    return Math.floor((leftTime / 1000) % 60);
}

function getTimerMinutes(leftTime) {
    if (0 > leftTime) {
        return 0;
    }

    return Math.floor(leftTime / 1000 / 60);
}

export class TimeLeftTicker extends Component {
    constructor(props) {
        super(props);
        this.state = {tickLeft: props.tickCount};
    }
    componentDidMount() {
        const {tickInterval = 1000} = this.props;

        this.interval = setInterval(this.onIntervalTick, tickInterval);
    }
    componentWillUnmount() {
        clearInterval(this.interval);
    }
    onIntervalTick = () => {
        const {onTickEnd} = this.props;
        const {tickLeft} = this.state;

        if (tickLeft === 1) {
            clearInterval(this.interval);
            return this.setState({tickLeft: 0}, onTickEnd);
        }

        this.setState({tickLeft: tickLeft - 1});
    };
    render() {
        const {tickInterval = 1000} = this.props;
        const {tickLeft} = this.state;
        const minutes = getTimerMinutes(tickLeft * tickInterval);
        const seconds = getTimerSeconds(tickLeft * tickInterval);

        return (
            <>
                {showWithLeadZero(minutes)}:{showWithLeadZero(seconds)}
            </>
        );
    }
}

TimeLeftTicker.propTypes = {
    tickCount: PropTypes.number,
    tickInterval: PropTypes.number,
    onTickEnd: PropTypes.func
};
