import './Title.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('Title');

export const Title = ({children, size, dataT, align}) => {
    const elemId = dataT ? `title:${dataT}` : 'title';

    return (
        <h1 data-t={elemId} id={dataT || undefined} className={b({size, align: align || (IS_AUTH_PAGE && 'center')})}>
            {children}
        </h1>
    );
};

Title.propTypes = {
    children: PropTypes.node.isRequired,
    size: PropTypes.string,
    dataT: PropTypes.string,
    align: PropTypes.oneOf(['center'])
};
