import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './UniversalTile.styl';
const b = cn('UniversalTile');

const BG_COLOR_MAP = {
    tintSuperLight: 'tintSuperLight',
    tintLight: 'tintLight'
};

const TILE_TYPES_MAP = {
    block: 'div',
    link: 'a',
    button: 'button'
};

export class UniversalTile extends React.PureComponent {
    _tileHandle = (event) => {
        const {handler} = this.props;

        if (!handler) {
            return;
        }

        event.preventDefault();

        handler(event);
    };

    render() {
        const {
            type,
            verticalAlignCenter = false,
            isTouch = false,
            isNoClickable = false,
            label = '',
            title = '',
            description = '',
            alert = '',
            leftComponent = null,
            rightComponent = null,
            href = '#',
            dataT = '',
            dataId = '',
            backgroundColor = '',
            backgroundHoverColor = '',
            titleEllipsisOverflow = false,
            descriptionEllipsisOverflow = false,
            isBorderBox = false,
            isBigPadding = false,
            isBigTitle = false,
            hasLeftComponentBg = false,
            preventRightComponentClick = false,
            disabled = false,
            handler = null
        } = this.props;

        const bgColorKey = `customBg_${BG_COLOR_MAP[backgroundColor]}`;
        const bgHoverColorKey = `customHoverBg_${BG_COLOR_MAP[backgroundHoverColor]}`;
        const titleEllipsis = Boolean(titleEllipsisOverflow || label);
        const noTitleMarginBottom = !description;
        const noDescriptionMarginBottom = !alert;
        const rightComponentCentered = Boolean(!description || label || (!label && !description));

        const TileComponent = TILE_TYPES_MAP[type] || 'div';
        const tileAttributes = {
            className: b({
                isTouch,
                verticalAlignCenter,
                isNoClickable,
                isNoInteractive: type === 'block' && !handler,
                isBorderBox,
                isBigPadding,
                disabled,
                [bgColorKey]: Boolean(BG_COLOR_MAP[backgroundColor]),
                [bgHoverColorKey]: Boolean(BG_COLOR_MAP[backgroundHoverColor])
            }),
            'data-t': dataT,
            ...(dataId && {'data-id': dataId}),
            ...(handler && {onClick: this._tileHandle}),
            ...(type === 'link' && {href})
        };

        return (
            <TileComponent {...tileAttributes}>
                {leftComponent && (
                    <div className={b('leftComponentWrapper', {hasLeftComponentBg})}>{leftComponent}</div>
                )}
                <div className={b('textBlock')}>
                    {label && <div className={b('label')}>{label}</div>}
                    {title && (
                        <div className={b('title', {titleEllipsis, noTitleMarginBottom, isBigTitle})}>{title}</div>
                    )}
                    {description && (
                        <div className={b('description', {descriptionEllipsisOverflow, noDescriptionMarginBottom})}>
                            {description}
                        </div>
                    )}
                    {alert && <div className={b('alert')}>{alert}</div>}
                </div>
                {rightComponent && (
                    <div className={b('rightComponentWrapper', {rightComponentCentered, preventRightComponentClick})}>
                        {rightComponent}
                    </div>
                )}
            </TileComponent>
        );
    }
}

UniversalTile.propTypes = {
    type: PropTypes.oneOf(['block', 'link', 'button']).isRequired,
    verticalAlignCenter: PropTypes.bool,
    label: PropTypes.string,
    title: PropTypes.string,
    description: PropTypes.string,
    alert: PropTypes.string,
    leftComponent: PropTypes.object,
    rightComponent: PropTypes.object,
    handler: PropTypes.func,
    isTouch: PropTypes.bool,
    isNoClickable: PropTypes.bool,
    href: PropTypes.string,
    dataT: PropTypes.string,
    dataId: PropTypes.string,
    backgroundColor: PropTypes.string,
    backgroundHoverColor: PropTypes.string,
    titleEllipsisOverflow: PropTypes.bool,
    descriptionEllipsisOverflow: PropTypes.bool,
    isBorderBox: PropTypes.bool,
    isBigPadding: PropTypes.bool,
    isBigTitle: PropTypes.bool,
    hasLeftComponentBg: PropTypes.bool,
    disabled: PropTypes.bool,
    preventRightComponentClick: PropTypes.bool
};
