import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {UniversalTile} from '@components/UniversalTile';
import './UniversalTileList.styl';

const b = cn('UniversalTileList');

const renderOneTile = (tile, index, arr) =>
    tile && (
        <React.Fragment key={index}>
            <div className={b('tile')}>
                <UniversalTile {...tile} />
            </div>
            {Boolean(arr[index + 1]) && <div className={b('sep')} />}
        </React.Fragment>
    );

export const UniversalTileList = ({tiles = []}) => <div className={b()}>{tiles.map(renderOneTile)}</div>;

UniversalTileList.propTypes = {
    tiles: PropTypes.array
};
