import {connect} from 'react-redux';
import {User} from 'pcomponents/User';
import {getLanguage, getSocialName, isMobile, hasExp} from '@blocks/selectors';

const LOGOUT_ORIGIN = 'passport_profile_head_logout';

const mapStateToProps = (state) => {
    const {settings = {}, common = {}, header = {}, dashboard = {}} = state;
    const {defaultAccount = {}, ci = ''} = header;
    const {uid, avatarId, displayName, mail, social = {}, plus: accountPlus = {}} = defaultAccount;
    const {yandexuid, currentPage} = common;
    const {tld, avatar, host, env: {type: envType} = {}, accountsUrl = ''} = settings;
    const plus = dashboard.plus || {};
    const isTesting = ['development', 'testing'].includes(envType);
    const isNewUserLegoComponent = hasExp(state, 'new-user-lego-component-exp');

    return {
        yu: yandexuid,
        uid,
        tld,
        retpath: currentPage,
        avatarId,
        avatarHost: `//${avatar.host}`,
        lang: getLanguage(state),
        name: displayName,
        subname: mail || getSocialName(social.provider) || '',
        hasPlus: plus.enabled || accountPlus.enabled,
        yaplusAvailable: plus.allowed,
        platform: isMobile(state) ? 'touch-phone' : 'desktop',
        isMobile: isMobile(state),
        passportHost: host,
        accountsUrl: accountsUrl.replace('%tld%', tld),
        logoutOrigin: LOGOUT_ORIGIN,
        ci,
        isTesting,
        isNewUserLegoComponent,
        customMenuItems: [
            {
                text: i18n('Frontend.exit'),
                // eslint-disable-next-line max-len
                url: `/passport?mode=embeddedauth&action=logout&yu=${yandexuid}&uid=${uid}&origin=${LOGOUT_ORIGIN}&retpath=${encodeURIComponent(
                    currentPage
                )}`,
                action: 'logout'
            }
        ]
    };
};

const ConnectedUser = connect(mapStateToProps)(User);

export {ConnectedUser as User};
