import React from 'react';
import {cn} from '@bem-react/classname';
import {Popup} from '@components/Popup';

import './VerifiedMark.styl';

const b = cn('VerifiedMark');

export class VerifiedMark extends React.PureComponent {
    ref = React.createRef();

    state = {
        isVisible: false
    };

    toggleVisibility = () => {
        this.setState((prevState) => ({
            isVisible: !prevState.isVisible
        }));
    };

    render() {
        return (
            <>
                <span
                    aria-label={i18n('Profile.verified.account')}
                    className={b()}
                    ref={this.ref}
                    onMouseEnter={this.toggleVisibility}
                    onMouseLeave={this.toggleVisibility}
                />
                <Popup
                    visible={this.state.isVisible}
                    directions={['bottom-center', 'bottom-left', 'bottom-right']}
                    hasTail={true}
                    target='anchor'
                    anchor={this.ref}
                    zIndex={9999}
                    view='black'
                >
                    <div className={b('tooltip')}>{i18n('Profile.verified.account')}</div>
                </Popup>
            </>
        );
    }
}
