import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classNames from 'classnames';
import {getLanguage} from '@blocks/selectors';

const APP_STORE_LINK = 'https://redirect.appmetrica.yandex.com/serve/386347106450828605?c=passport_bage';
const GOOGLE_PLAY_LINK = 'https://redirect.appmetrica.yandex.com/serve/458404701881276453?c=passport_bage';

class YandexAppButtons extends React.PureComponent {
    _maybeRenderTitle = () => {
        const {hideTitle} = this.props;

        if (hideTitle) {
            return null;
        }

        return <h3 className={`passp-install-yandex-app-title`}>{i18n('_AUTH_.AuthQR.promo.app_title')}</h3>;
    };

    _renderIcon = (market, href) => {
        const {lang} = this.props;
        const iconLang = !lang || ['ru', 'uk'].includes(lang) ? 'ru' : 'en';

        return (
            <a className={`passp-install-yandex-app-link`} href={href}>
                <span className={classNames(['passp-icon', `passp-${market}`, `passp-${market}-${iconLang}`])} />
            </a>
        );
    };

    render() {
        return (
            <div>
                {this._maybeRenderTitle()}

                <div className={`passp-install-yandex-app-links passp-clearfix`}>
                    {this._renderIcon('googleplay', GOOGLE_PLAY_LINK)}
                    {this._renderIcon('appstore', APP_STORE_LINK)}
                </div>
            </div>
        );
    }
}

YandexAppButtons.propTypes = {
    lang: PropTypes.string.isRequired,
    hideTitle: PropTypes.bool
};

function mapStateToProps(state) {
    return {lang: getLanguage(state)};
}

const ConnectedYandexAppButtons = connect(mapStateToProps)(YandexAppButtons);

export {ConnectedYandexAppButtons as YandexAppButtons};
