import api from '@blocks/api';
import {getTrackId, getRedirectUrl} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {sendMessage} from '@blocks/utils';
import {setLoading, setError, setStep, setCheckbox, setEmail, setCode} from './actions';
import {EMAIL_CONFIRM_STEPS} from './const';

const sendPostMessage = (eventName, value, state) => {
    const retpath = getRedirectUrl(state);
    const data = {eventName};

    if (value) {
        data.value = value;
    }

    return sendMessage(data, retpath);
};

export const makeRequest = (dispatch, method, data = {}, state) => {
    dispatch(setLoading(true));
    return api
        .request(method, data)
        .fail(({errors}) => {
            const error = errors[0];

            sendPostMessage('error', error, state);
            dispatch(setError(error));
        })
        .always(() => dispatch(setLoading(false)));
};

export const goToNextStep = () => (dispatch, getState) => {
    const {emailConfirm} = getState() || {};
    const {step} = emailConfirm || {};

    switch (step) {
        case EMAIL_CONFIRM_STEPS.ADD:
            return dispatch(setStep(EMAIL_CONFIRM_STEPS.CODE));
        case EMAIL_CONFIRM_STEPS.CODE:
            return dispatch(setStep(EMAIL_CONFIRM_STEPS.SUCCESS));
    }
};

export const goToFirstStep = () => (dispatch) => dispatch(setStep(EMAIL_CONFIRM_STEPS.ADD));

export const toggleCheckbox = (name) => (dispatch, getState) => {
    const state = getState();
    const {emailConfirm} = state || {};
    const {checkboxes} = emailConfirm || {};
    const checkbox = checkboxes.find((i) => i.name === name);

    if (checkbox) {
        const payload = {name, checked: !checkbox.checked};

        sendPostMessage('checkbox', payload, state);
        dispatch(setCheckbox(payload));
    }
};

export const changeEmail = (value) => (dispatch) => dispatch(setEmail(value));

export const postEmailCreate = () => (dispatch, getState) => {
    const state = getState();
    const {emailConfirm: {email} = {}, common = {}, settings = {}} = state;
    const data = {
        email,
        retpath: common.retpath,
        language: settings.language,
        uid: common.uid,
        track_id: getTrackId(state, TRACK_TYPES.COMMON),
        validator_ui_url: common.emailValidatorUiUrl,
        is_safe: false,
        code_only: true
    };

    return makeRequest(dispatch, 'email/send-confirmation-email', data, state).done(() => dispatch(setCode('')));
};

export const changeCode = (value) => (dispatch) => dispatch(setCode(value));

export const postEmailCode = () => (dispatch, getState) => {
    const state = getState() || {};
    const {emailConfirm} = state;
    const {code} = emailConfirm || {};
    const data = {
        track_id: getTrackId(state, TRACK_TYPES.COMMON),
        key: code ? code.trim() : ''
    };

    return makeRequest(dispatch, 'email/confirm-by-code', data, state);
};

export const sendPostMessageHeight = () => (dispatch, getState) => {
    sendPostMessage('height', document.getElementById('EmailConfirm').scrollHeight, getState());
};

export const postMessage = (eventName, value) => (dispatch, getState) => sendPostMessage(eventName, value, getState());
export {postMessage as sendPostMessage};
