import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {EMAIL_CONFIRM_STEPS} from '../../const';
import {cn} from '@bem-react/classname';

import './EmailConfirmButtons.styl';

const b = cn('EmailConfirmButtons');

const isCheckboxNotRequiredOrChecked = (checkbox) => !checkbox.required || checkbox.checked;

export class EmailConfirmButtons extends Component {
    onAddClick = () => {
        const {goToNextStep, postEmailCreate, isEmailInProgress} = this.props;

        return isEmailInProgress ? goToNextStep() : postEmailCreate().done(goToNextStep);
    };
    onCodeConfirmClick = () => {
        const {goToNextStep, postEmailCode} = this.props;

        return postEmailCode().done(goToNextStep);
    };
    onCancelClick = () => {
        const {isEmailExternal, step, goToFirstStep, sendPostMessage} = this.props;

        return step === EMAIL_CONFIRM_STEPS.CODE && !isEmailExternal ? goToFirstStep() : sendPostMessage('cancel');
    };
    onSuccessClick = () => {
        const {email, checkboxes, sendPostMessage} = this.props;

        sendPostMessage('success', {email, checkboxes: checkboxes.filter((i) => i.checked).map((i) => i.name)});
    };
    onFailClick = () => {
        const {error, sendPostMessage} = this.props;

        sendPostMessage('fail', error);
    };
    getButtons = () => {
        const {step, email, code, checkboxes, isLoading} = this.props;

        switch (step) {
            case EMAIL_CONFIRM_STEPS.ADD:
                return [
                    {view: 'clear', text: i18n('_AUTH_.common.cancel'), onClick: this.onCancelClick},
                    {
                        view: 'action',
                        text: i18n('Profile.common.add'),
                        onClick: this.onAddClick,
                        disabled: !(email && checkboxes.every(isCheckboxNotRequiredOrChecked)),
                        isLoading
                    }
                ];
            case EMAIL_CONFIRM_STEPS.CODE:
                return [
                    {view: 'clear', text: i18n('_AUTH_.common.cancel'), onClick: this.onCancelClick},
                    {
                        view: 'action',
                        text: i18n('Profile.common.confirm'),
                        onClick: this.onCodeConfirmClick,
                        disabled: !code,
                        isLoading
                    }
                ];
            case EMAIL_CONFIRM_STEPS.FAIL:
                return [{view: 'default', text: i18n('Profile.emails.change-email'), onClick: this.onFailClick}];
            case EMAIL_CONFIRM_STEPS.SUCCESS:
                return [{view: 'action', text: i18n('Profile.common.continue'), onClick: this.onSuccessClick}];
            default:
                return [];
        }
    };
    render() {
        const {step} = this.props;

        return (
            <div className={b({step})}>
                {this.getButtons().map(({text, isLoading, ...buttonProps}, i) => (
                    <div key={i} className={b('button')}>
                        <Button {...buttonProps} progress={isLoading} width='max' size='l'>
                            {text}
                        </Button>
                    </div>
                ))}
            </div>
        );
    }
}

EmailConfirmButtons.propTypes = {
    step: PropTypes.string,
    email: PropTypes.string,
    code: PropTypes.string,
    error: PropTypes.string,
    checkboxes: PropTypes.array,
    goToFirstStep: PropTypes.func,
    goToNextStep: PropTypes.func,
    postEmailCreate: PropTypes.func,
    postEmailCode: PropTypes.func,
    sendPostMessage: PropTypes.func,
    isAddButtonDisabled: PropTypes.bool,
    isCodeButtonDisabled: PropTypes.bool,
    isEmailInProgress: PropTypes.bool,
    isEmailExternal: PropTypes.bool,
    isLoading: PropTypes.bool
};
