import {connect} from 'react-redux';

import {EmailConfirmButtons as Buttons} from './EmailConfirmButtons';
import {goToFirstStep, goToNextStep, postEmailCreate, postEmailCode, sendPostMessage} from '../../api';

const mapStateToProps = ({emailConfirm}) => {
    const {step, checkboxes, email, code, isEmailInProgress, isLoading, isEmailExternal} = emailConfirm || {};

    return {step, code, checkboxes, email, isEmailInProgress, isLoading, isEmailExternal};
};

const mapDispatchToProps = {goToFirstStep, goToNextStep, postEmailCreate, postEmailCode, sendPostMessage};

export const EmailConfirmButtons = connect(mapStateToProps, mapDispatchToProps)(Buttons);
