import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {EMAIL_CONFIRM_STEPS} from '../../const';
import {EmailConfirmAddPage, EmailConfirmCodePage, EmailConfirmFailPage, EmailConfirmSuccessPage} from '../../pages';

export class EmailConfirmPage extends Component {
    componentDidUpdate(props) {
        if (props.step !== this.props.step) {
            this.onStepChange();
        }
    }
    componentDidMount() {
        this.onStepChange();
    }
    onStepChange = () => {
        const {sendPostMessage, sendPostMessageHeight, step} = this.props;

        sendPostMessageHeight();
        sendPostMessage('step', step);
    };
    render() {
        const {step} = this.props;

        switch (step) {
            case EMAIL_CONFIRM_STEPS.ADD:
                return <EmailConfirmAddPage />;
            case EMAIL_CONFIRM_STEPS.CODE:
                return <EmailConfirmCodePage />;
            case EMAIL_CONFIRM_STEPS.FAIL:
                return <EmailConfirmFailPage />;
            case EMAIL_CONFIRM_STEPS.SUCCESS:
                return <EmailConfirmSuccessPage />;
            default:
                return null;
        }
    }
}

EmailConfirmPage.propTypes = {
    step: PropTypes.string,
    sendPostMessage: PropTypes.func,
    sendPostMessageHeight: PropTypes.func
};
