import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {Spin} from '@components/Spin';
import {cn} from '@bem-react/classname';

import './EmailConfirmExample.styl';

const b = cn('EmailConfirmExample');

export class EmailConfirmExample extends Component {
    state = {isIframeLoading: true};
    componentDidMount() {
        window.onmessage = (e) => {
            if (
                e.data &&
                typeof e.data !== 'string' &&
                e.source === window.frames['email-confirm-example'] &&
                e.target === window
            ) {
                // eslint-disable-next-line no-console
                console.log('postMessage:', e.data);

                if (e.data.eventName === 'height') {
                    document.getElementById('EmailConfirm').style.height = `${e.data.value}px`;
                }
                if (e.data.eventName === 'init') {
                    this.setState({isIframeLoading: false});
                }
            }
        };
    }
    render() {
        const {iframeSrc} = this.props;
        const {isIframeLoading} = this.state;

        return (
            <Modal visible={true}>
                <div className={b({})}>
                    {isIframeLoading && (
                        <div className={b('loader')}>
                            <Spin progress={true} size='l' />
                        </div>
                    )}
                    <iframe
                        className={b('iframe')}
                        src={iframeSrc}
                        name='email-confirm-example'
                        id='EmailConfirm'
                        style={{height: '0'}}
                    />
                </div>
            </Modal>
        );
    }
}

EmailConfirmExample.propTypes = {
    iframeSrc: PropTypes.string
};
