import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {getError} from '@blocks/utils';
import {Input} from '@components/Input';
import {Checkbox} from '@components/Checkbox';
import {cn} from '@bem-react/classname';

import './EmailConfirmAddPage.styl';

const b = cn('EmailConfirmAddPage');

export class EmailConfirmAddPage extends Component {
    componentDidUpdate(props) {
        const {error, sendPostMessageHeight} = this.props;

        if (error !== props.error) {
            sendPostMessageHeight();
        }
    }
    onInputChange = (e) => {
        const {changeEmail} = this.props;

        if (e && e.target) {
            changeEmail(e.target.value);
        }
    };
    toggleCheckbox = (e) => {
        const {toggleCheckbox} = this.props;

        if (e && e.target && e.target.name) {
            toggleCheckbox(e.target.name);
        }
    };
    render() {
        const {checkboxes, email, error} = this.props;

        return (
            <div className={b()}>
                <div className={b('title')}>{i18n('EmailConfirm.pages.add.title')}</div>
                <div className={b('text')}>{i18n('EmailConfirm.pages.add.text')}</div>
                <div className={b('input')}>
                    <Input
                        hint={error && getError('email', error).text}
                        state={error && 'error'}
                        size='xl'
                        placeholder={i18n('EmailConfirm.pages.add.input')}
                        width='max'
                        value={email}
                        name='email'
                        onChange={this.onInputChange}
                    />
                </div>
                <div className={b('checkboxes')}>
                    {checkboxes.map((checkbox, i) => (
                        <div className={b('checkbox')} key={i}>
                            <Checkbox
                                checked={checkbox.checked}
                                label={checkbox.label}
                                size='l'
                                onChange={this.toggleCheckbox}
                                name={checkbox.name}
                            />
                        </div>
                    ))}
                </div>
            </div>
        );
    }
}

EmailConfirmAddPage.propTypes = {
    checkboxes: PropTypes.arrayOf(
        PropTypes.shape({
            checked: PropTypes.bool,
            label: PropTypes.string,
            name: PropTypes.string
        })
    ),
    email: PropTypes.string,
    error: PropTypes.string,
    toggleCheckbox: PropTypes.func,
    changeEmail: PropTypes.func,
    sendPostMessageHeight: PropTypes.func
};
