import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {getError} from '@blocks/utils';
import {Input} from '@components/Input';
import {cn} from '@bem-react/classname';

import './EmailConfirmCodePage.styl';

const b = cn('EmailConfirmCodePage');

export class EmailConfirmCodePage extends Component {
    errorKeyset = 'email_code';
    onInputChange = ({target} = {}) => {
        const {changeCode} = this.props;

        if (target) {
            changeCode(target.value);
        }
    };
    componentDidUpdate(props) {
        const {error, sendPostMessageHeight} = this.props;

        if (error !== props.error) {
            sendPostMessageHeight();
            if (!error) {
                this.errorKeyset = 'emailCode';
            }
        }
    }
    onResendClick = () => {
        const {postEmailCreate} = this.props;

        this.errorKeyset = 'email';
        postEmailCreate();
    };
    onChangeClick = () => {
        const {goToFirstStep, sendPostMessage, isEmailExternal} = this.props;

        return isEmailExternal ? sendPostMessage('change') : goToFirstStep();
    };

    render() {
        const {email, code, error} = this.props;
        const errorText = error && (getError(this.errorKeyset, error) || {text: ''}).text;

        return (
            <div className={b()}>
                <div className={b('title')}>{i18n('EmailConfirm.pages.code.title')}</div>
                <div className={b('text')}>
                    <span
                        dangerouslySetInnerHTML={{
                            __html: i18n('EmailConfirm.pages.code.text').replace('%1', `<b>${email}</b>`)
                        }}
                    />{' '}
                    <span className={b('link')} onClick={this.onChangeClick}>
                        {i18n('EmailConfirm.pages.code.text.link')}
                    </span>
                </div>
                <div className={b('input')}>
                    <Input
                        hint={errorText}
                        state={error && 'error'}
                        size='xl'
                        name='code'
                        placeholder={i18n('EmailConfirm.pages.code.input')}
                        width='max'
                        value={code}
                        onChange={this.onInputChange}
                    />
                </div>
                <div className={b('resend')} onClick={this.onResendClick}>
                    {i18n('EmailConfirm.pages.code.resend')}
                </div>
            </div>
        );
    }
}

EmailConfirmCodePage.propTypes = {
    email: PropTypes.string,
    code: PropTypes.string,
    error: PropTypes.string,
    changeCode: PropTypes.func,
    goToFirstStep: PropTypes.func,
    postEmailCreate: PropTypes.func,
    sendPostMessage: PropTypes.func,
    sendPostMessageHeight: PropTypes.func,
    isEmailExternal: PropTypes.bool
};
