import React from 'react';
import PropTypes from 'prop-types';
import {getError} from '@blocks/utils';
import {cn} from '@bem-react/classname';

import './EmailConfirmFailPage.styl';

const b = cn('EmailConfirmFailPage');

export const EmailConfirmFailPage = ({error}) => (
    <div className={b()}>
        <div className={b('icon')}>
            <svg fill='none' height='80' viewBox='3 3 49 49' width='80' xmlns='http://www.w3.org/2000/svg'>
                <linearGradient
                    id='a'
                    gradientUnits='userSpaceOnUse'
                    x1='4.00058'
                    x2='36.2759'
                    y1='.957747'
                    y2='60.1838'
                >
                    <stop offset='0' stopColor='#ff101e' />
                    <stop offset='1' stopColor='#ff457d' />
                </linearGradient>
                <path
                    clipRule='evenodd'
                    // eslint-disable-next-line max-len
                    d='m49 28c0 11.598-9.402 21-21 21s-21-9.402-21-21 9.402-21 21-21 21 9.402 21 21zm3 0c0 13.2548-10.7452 24-24 24s-24-10.7452-24-24 10.7452-24 24-24 24 10.7452 24 24zm-35.0606-11.0607c.5858-.5858 1.5355-.5858 2.1213 0l8.9393 8.9394 8.9394-8.9394c.5858-.5858 1.5355-.5858 2.1213 0s.5858 1.5356 0 2.1213l-8.9394 8.9394 8.9394 8.9393c.5858.5858.5858 1.5356 0 2.1213-.5858.5858-1.5355.5858-2.1213 0l-8.9394-8.9393-8.9393 8.9393c-.5858.5858-1.5355.5858-2.1213 0-.5858-.5857-.5858-1.5355 0-2.1213l8.9393-8.9393-8.9393-8.9394c-.5858-.5857-.5858-1.5355 0-2.1213z'
                    fill='url(#a)'
                    fillRule='evenodd'
                />
            </svg>
        </div>
        <div className={b('title')}>{i18n('EmailConfirm.pages.fail.title')}</div>
        <div className={b('text')}>{getError('email', error).text}</div>
    </div>
);

EmailConfirmFailPage.propTypes = {
    error: PropTypes.string
};
