import {EMAIL_CONFIRM_STEPS} from '../const';
import {SET_STEP, SET_CHECKBOX, SET_CODE, SET_EMAIL, SET_LOADING, SET_ERROR} from '../actions';

const defaultState = {
    step: EMAIL_CONFIRM_STEPS.ADD,
    email: '',
    code: '',
    checkboxes: [],
    isEmailInProgress: false,
    isEmailExternal: false,
    error: null,
    isLoading: false,
    isExample: true
};

export const emailConfirm = (state = defaultState, action = {}) => {
    const {type, payload} = action;

    switch (type) {
        case SET_LOADING:
            return Object.assign({}, state, {isLoading: payload});
        case SET_ERROR:
            return Object.assign({}, state, {error: payload});
        case SET_STEP:
            return Object.assign({}, state, {step: payload, error: null});
        case SET_EMAIL:
            return Object.assign({}, state, {email: payload, isEmailInProgress: false, code: '', error: null});
        case SET_CHECKBOX:
            return Object.assign({}, state, {
                checkboxes: state.checkboxes.map((checkbox) =>
                    checkbox.name === payload.name ? Object.assign({}, checkbox, {checked: payload.checked}) : checkbox
                )
            });
        case SET_CODE:
            return Object.assign({}, state, {isEmailInProgress: true, code: payload, error: null});
        default:
            return state;
    }
};
