import React from 'react';
import PropTypes from 'prop-types';
import {PasswordEnterIcon} from '../../Icons/PasswordEnterIcon';
import {PasswordAndSmsIcon} from '../../Icons/PasswordAndSmsIcon';
import {SmsEnterIcon} from '../../Icons/SmsEnterIcon';
import {YaKeyIcon} from '../../Icons/YaKeyIcon';
import {CheckIcon} from '../../Icons/CheckIcon';
import {SocialIcon} from '../../Icons/SocialIcon';
import {QrIcon} from '../../Icons/QrIcon';
import {ArrowIcon} from '../../Icons/ArrowIcon';
import {Tumbler} from '@components/Tumbler';
import {UniversalTile} from '@blocks/Components/UniversalTile/UniversalTile';
import {cn} from '@bem-react/classname';
import '../../LoginMethod.styl';
const b = cn('LoginMethod');

class MethodList extends React.PureComponent {
    _qrToggle = () => {
        const {toggleEnterWithoutPassword, person} = this.props;

        const {loginOptions: {qrCodeLoginForbidden, smsCodeLoginForbidden} = {}} = person;
        const params = {
            qrCodeLoginForbidden: !qrCodeLoginForbidden,
            smsCodeLoginForbidden
        };

        toggleEnterWithoutPassword(params);
    };

    _openPhoneBindConfirmModal = () => {
        const {setEditMode} = this.props;

        setEditMode('phoneBindConfirm');
    };

    _renderAddMethodIndicator = (isOn) => {
        return (
            <div className={b('socialIndicatorWrapper')}>
                {isOn && <div className={b('socialIndicatorText')}>{i18n('Frontend.login-method.indicator-text')}</div>}
                <ArrowIcon />
            </div>
        );
    };

    _renderBasicMethods = () => {
        const {isTouch, person, access, methodLinks} = this.props;
        const {is2faEnabled, isSms2faEnabled} = access;
        const {isNeoPhonish, isLiteUser, isSocialchik, havePassword} = person;
        const isNoPortal = (isLiteUser || isSocialchik || isNeoPhonish) && !havePassword;
        const isLoginAndSmsDefault = havePassword && isSms2faEnabled && !is2faEnabled;
        const isLoginDefault = havePassword && !isSms2faEnabled && !is2faEnabled;

        return (
            <div className={b('methodsList')}>
                <div className={b('methodItem')}>
                    <UniversalTile
                        type='link'
                        isTouch={isTouch}
                        leftComponent={<PasswordEnterIcon />}
                        rightComponent={isLoginDefault ? <CheckIcon /> : null}
                        title={i18n('Frontend.login-method.method-title-pass')}
                        description={i18n('Frontend.login-method.method-description-pass')}
                        isNoClickable={isLoginDefault}
                        href={is2faEnabled ? methodLinks.loginFor2fa : methodLinks.login}
                        handler={isLoginAndSmsDefault ? this._openPhoneBindConfirmModal : null}
                        dataT={'login-method-pass'}
                    />
                </div>

                {isNeoPhonish && (
                    <div className={b('methodItem')}>
                        <UniversalTile
                            type='link'
                            isTouch={isTouch}
                            leftComponent={<SmsEnterIcon />}
                            rightComponent={isNeoPhonish ? <CheckIcon /> : null}
                            title={i18n('Frontend.login-method.method-title-sms')}
                            description={i18n('Frontend.login-method.method-description-sms')}
                            isNoClickable={isNeoPhonish}
                            href={methodLinks.loginAndSmsForNoPortal}
                            dataT={'login-method-sms'}
                        />
                    </div>
                )}

                <div className={b('methodItem')}>
                    <UniversalTile
                        type='link'
                        isTouch={isTouch}
                        leftComponent={<PasswordAndSmsIcon />}
                        rightComponent={isLoginAndSmsDefault ? <CheckIcon /> : null}
                        title={i18n('Frontend.login-method.method-title-pass-sms')}
                        description={i18n('Frontend.login-method.method-description-pass-sms')}
                        isNoClickable={isLoginAndSmsDefault}
                        handler={isLoginDefault ? this._openPhoneBindConfirmModal : null}
                        href={is2faEnabled ? methodLinks.loginAndSmsFor2fa : methodLinks.loginAndSmsForNoPortal}
                        dataT={'login-method-pass-sms'}
                    />
                </div>

                <div className={b('methodItem')}>
                    <UniversalTile
                        type='link'
                        isTouch={isTouch}
                        leftComponent={<YaKeyIcon />}
                        rightComponent={is2faEnabled ? <CheckIcon /> : null}
                        title={i18n('Frontend.login-method.method-title-2fa')}
                        description={i18n('Frontend.login-method.method-description-2fa')}
                        isNoClickable={is2faEnabled}
                        href={isNoPortal ? methodLinks['2faForNoPortal'] : methodLinks['2faForPortal']}
                        dataT={'login-method-2fa'}
                    />
                </div>
            </div>
        );
    };

    _renderAddMethods = () => {
        const {isBasic, isTouch, person, access, allowSocialAuth, methodLinks} = this.props;
        const {isSms2faEnabled, is2faEnabled} = access;
        const {loginOptions, isNeoPhonish, isLiteUser, havePassword} = person;
        const {qrCodeLoginForbidden} = loginOptions;
        const isSuperLite = isLiteUser && !havePassword;

        const showSocialMethod = !isNeoPhonish && !isSms2faEnabled && !is2faEnabled;
        const showQrMethod = !isNeoPhonish && !isSuperLite;

        return (
            <div className={b('methodsList', {add: !isBasic})}>
                {showSocialMethod && (
                    <div className={b('methodItem')}>
                        <UniversalTile
                            type='link'
                            isTouch={isTouch}
                            leftComponent={<SocialIcon />}
                            rightComponent={this._renderAddMethodIndicator(allowSocialAuth)}
                            title={i18n('Frontend.login-method.method-title-social')}
                            description={i18n('Frontend.login-method.method-description-social')}
                            href={methodLinks.social}
                            dataT={'login-method-social'}
                        />
                    </div>
                )}

                {showQrMethod && (
                    <div className={b('methodItem')}>
                        <UniversalTile
                            type='block'
                            isTouch={isTouch}
                            leftComponent={<QrIcon />}
                            rightComponent={
                                <Tumbler size='m' checked={!qrCodeLoginForbidden} onChange={this._qrToggle} />
                            }
                            title={i18n('Frontend.login-method.method-title-qr')}
                            description={i18n('Frontend.login-method.method-description-qr')}
                            dataT={'login-method-qr'}
                        />
                    </div>
                )}
            </div>
        );
    };

    render() {
        const {isBasic} = this.props;

        return isBasic ? this._renderBasicMethods() : this._renderAddMethods();
    }
}

MethodList.propTypes = {
    isBasic: PropTypes.bool.isRequired,
    isTouch: PropTypes.bool.isTouch,
    access: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    allowSocialAuth: PropTypes.bool.isRequired,
    toggleEnterWithoutPassword: PropTypes.func,
    setEditMode: PropTypes.func,
    methodLinks: PropTypes.object.isRequired
};

export {MethodList};
