import {connect} from 'react-redux';
import {MethodList} from './MethodList';
import {toggleEnterWithoutPassword} from '@blocks/morda/personal_info/effects/enter_without_password';
import {setEditMode} from '@blocks/common/actions';

const mapStateToProps = (state = {}) => {
    const {
        person = {},
        settings = {},
        access = {},
        social = {},
        common: {currentPage = ''} = {},
        loginMethod: {methodLinks = {}} = {}
    } = state;
    const {ua: {isTouch} = {}} = settings;
    const {profiles = []} = social;
    const allowSocialAuth = profiles.findIndex((el) => el.allowAuth) !== -1;

    return {
        person,
        access,
        isTouch,
        allowSocialAuth,
        currentPage,
        methodLinks
    };
};

const mapDispatchToProps = {
    toggleEnterWithoutPassword,
    setEditMode
};

const connectedMethodList = connect(mapStateToProps, mapDispatchToProps)(MethodList);

export {connectedMethodList as MethodList};
