import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {MethodList} from './Components/MethodList';
import {Link} from '@components/Link';
import {InfoIcon} from './Icons/InfoIcon';
import {CloseIcon} from './Icons/CloseIcon';
import {BackButton} from '@components/BackButton';
import {Spin} from '@components/Spin';
import './LoginMethod.styl';
import metrika from '@blocks/metrics';
const b = cn('LoginMethod');

const LINKS = {
    toProfileUpgrade: '/profile/upgrade?origin=profile_loginmethod',
    toInfoLanding: 'https://id.yandex.%tld%/howtoprotectyourid',
    toProfile: '/profile'
};
const sendMetrics = () => metrika.send('Нажали на "Узнать больше" в способах входа');

class LoginMethod extends React.PureComponent {
    _onClose = () => {
        const {isModal, closeModal} = this.props;

        if (isModal) {
            closeModal();
            return;
        }

        window.location.href = LINKS.toProfile;
    };

    render() {
        const {isTouch, person, access, isModal, tld, hasLandingExp, isLoading, isNewLayout} = this.props;
        const {isNeoPhonish, isLiteUser, isSocialchik, havePassword} = person;
        const {is2faEnabled} = access;

        const showLoginInfo = (isNeoPhonish || isLiteUser || isSocialchik) && !havePassword;
        const showAddMethods = !is2faEnabled && !isNeoPhonish;

        return (
            <div className={b('wrapper', {isTouch, isModal, isTouchAndModal: isTouch && isModal, isNewLayout})}>
                {isModal ? (
                    <button type='button' className={b('close', {isTouch, isModal})} onClick={this._onClose}>
                        <CloseIcon />
                    </button>
                ) : (
                    <div className={b('backButtonWrapper', {isTouch, isNewLayout})}>
                        <BackButton mode='arrowBack' place='newLayout' onClick={this._onClose} />
                    </div>
                )}

                <div className={b('title')}>{i18n('Frontend.login-method.title')}</div>
                <div className={b('description')}>
                    {i18n('Frontend.login-method.description')}
                    {hasLandingExp && (
                        <Link
                            onClick={sendMetrics}
                            theme='ghost'
                            view='ghost'
                            href={LINKS.toInfoLanding.replace('%tld%', tld === 'ru' ? tld : 'com')}
                            className={b('descriptionLink')}
                        >
                            {i18n('Frontend.login-method.description-link')}
                        </Link>
                    )}
                </div>

                {showLoginInfo && (
                    <div className={b('loginInfo', {isTouch})}>
                        <div className={b('loginInfoText')}>
                            {i18n('Frontend.login-method.login-info-text')}
                            <Link
                                theme='ghost'
                                view='ghost'
                                href={LINKS.toProfileUpgrade}
                                className={b('loginInfoLink')}
                            >
                                {i18n('Frontend.login-method.login-info-link')}
                            </Link>
                        </div>
                        <InfoIcon />
                    </div>
                )}

                <div className={b('subTitle')}>{i18n('Frontend.login-method.sub-title-main')}</div>

                <MethodList isBasic={true} />

                {showAddMethods && (
                    <>
                        <div className={b('subTitle')}>{i18n('Frontend.login-method.sub-title-add')}</div>

                        <MethodList isBasic={false} />
                    </>
                )}

                {isLoading && (
                    <>
                        <div className={b('loaderOverlay')} />
                        <Spin className={b('loader')} progress={true} size='l' />
                    </>
                )}
            </div>
        );
    }
}

LoginMethod.propTypes = {
    isModal: PropTypes.bool,
    closeModal: PropTypes.func,
    isTouch: PropTypes.bool.isRequired,
    access: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    tld: PropTypes.string.isRequired,
    hasLandingExp: PropTypes.bool,
    isLoading: PropTypes.bool.isRequired,
    isNewLayout: PropTypes.bool
};

export {LoginMethod};
