import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {LoginMethod} from './';
import {Link} from '@components/Link';
import {setEditMode} from '@blocks/common/actions';
import Modal from '@components/Wrappers/Modal.jsx';
import {cn} from '@bem-react/classname';
import './LoginMethod.styl';

const b = cn('LoginMethodModal');

class LoginMethodModal extends PureComponent {
    componentDidMount() {
        const {setEditMode, openLoginMethodModal} = this.props;

        if (openLoginMethodModal) {
            setEditMode('loginMethod');
        }
    }

    closeModal = () => {
        const {setEditMode} = this.props;

        setEditMode('');
    };

    openModal = () => {
        const {setEditMode} = this.props;

        setEditMode('loginMethod');
    };

    render() {
        const {isOpened, person, access, isTouch} = this.props;
        const {is2faEnabled, isSms2faEnabled} = access;
        const {isNeoPhonish, isLiteUser, isSocialchik, havePassword} = person;

        const isLiteOrSocial = (isLiteUser || isSocialchik) && !havePassword;
        const isLoginAndSmsDefault = havePassword && isSms2faEnabled && !is2faEnabled;
        const isLoginDefault = havePassword && !isSms2faEnabled && !is2faEnabled;

        return (
            <div data-t='login-method-modal-block'>
                <div className='s-block__sub s-block__sub_hl'>
                    <Link pseudo={true} onClick={this.openModal}>
                        {!isLiteOrSocial && i18n('Frontend.login-method.modal-link-title')}
                        {isLiteOrSocial && i18n('Frontend.login-method.modal-link-title-v2')}
                    </Link>
                </div>
                <Modal visible={isOpened} dataT='login-method-modal' className={b({isTouch})}>
                    {isOpened && <LoginMethod isModal={true} closeModal={this.closeModal} isOpened={isOpened} />}
                </Modal>
                <div className='s-block__sub'>
                    {isLiteOrSocial && i18n('Frontend.login-method.modal-link-description-lite')}
                    {isNeoPhonish && i18n('Frontend.login-method.modal-link-description-phonish')}
                    {isLoginDefault && i18n('Frontend.login-method.modal-link-description-pass')}
                    {isLoginAndSmsDefault && i18n('Frontend.login-method.modal-link-description-pass-sms')}
                    {is2faEnabled && i18n('Frontend.login-method.modal-link-description-2fa')}
                </div>
            </div>
        );
    }
}

LoginMethodModal.propTypes = {
    isOpened: PropTypes.bool.isRequired,
    setEditMode: PropTypes.func.isRequired,
    person: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    isTouch: PropTypes.bool.isRequired,
    openLoginMethodModal: PropTypes.bool
};

const mapStateToProps = (state = {}) => {
    const {common = {}, person = {}, access = {}, settings = {}, loginMethod = {}} = state;
    const {ua: {isTouch} = {}} = settings;
    const {edit} = common;
    const {openLoginMethodModal} = loginMethod;

    return {
        person,
        access,
        isOpened: edit === 'loginMethod',
        isTouch,
        openLoginMethodModal
    };
};

const mapDispatchToProps = {
    setEditMode
};

const ConnectedLoginMethodModal = connect(mapStateToProps, mapDispatchToProps)(LoginMethodModal);

export {ConnectedLoginMethodModal as LoginMethodModal};
