import {connect} from 'react-redux';
import {LoginMethod} from './LoginMethod';
import {hasExp} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {person = {}, settings = {}, access = {}, common = {}, loginMethod = {}} = state;
    const {ua: {isTouch} = {}} = settings;
    const {tld = 'ru', isNewLayout} = settings;
    const hasLandingExp = hasExp({common}, 'show_landing_link_exp');
    const {isLoading = false} = loginMethod;

    return {
        person,
        access,
        isTouch,
        tld,
        hasLandingExp,
        isLoading,
        isNewLayout
    };
};

const connectedLoginMethod = connect(mapStateToProps)(LoginMethod);

export {connectedLoginMethod as LoginMethod};
