import {combineReducers} from 'redux';
import personReducer from '@blocks/morda/personal_info/reducers';
import access from '@blocks/morda/access/reducers';
import header from '@blocks/morda/components/header/reducers';
import common from '@blocks/common/reducers';
import social from '@blocks/morda/social_info/reducers';
import phoneConfirm from '@blocks/reducers/phoneConfirm';
import form from '@blocks/reducers/form';
import phones from '@blocks/phones/reducer';
import {IS_LOGIN_METHOD_LOADING} from './actions';

const initialState = {
    isLoading: false
};

function person(state, action) {
    return personReducer(state, action);
}

const stub = (state = {}) => state;
const rootReducer = combineReducers({
    person,
    access,
    common,
    header,
    social,
    form,
    phoneConfirm,
    phones,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    tracks: stub,
    loginMethod
});

export default rootReducer;

export function loginMethod(state = initialState, action = {}) {
    const {type, payload} = action;

    switch (type) {
        case IS_LOGIN_METHOD_LOADING: {
            return {
                ...state,
                isLoading: payload
            };
        }
        default:
            return state;
    }
}
