import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';
import './AuthInfo.styl';
import {STEPS} from '@blocks/Security/config';

const b = cn('AuthInfo');

export class AuthInfo extends Component {
    proceedToFinalScreen = () => {
        this.props.setNextStep(STEPS.FINISH);
    };

    proceedToChangePassword = () => {
        this.props.setNextStep(STEPS.PASSWORD_FORM);
    };

    render() {
        const {authInfo} = this.props;

        return (
            <main className={b('container')}>
                <div className={b('header-icon')} role='presentation' aria-hidden='true'>
                    <div className={b('header-avatar')} />
                    <div className={b('shield', {securityLevel: 'low'})} />
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{i18n('ProfileSecurity.notme.enter_title')}</h2>
                    <div className={b('description')}>
                        <p>
                            {authInfo.date} в {authInfo.time} кто-то зашёл в ваш аккаунт
                        </p>
                        <ul className={b('details')}>
                            <li>
                                <strong>место</strong>: {authInfo.place}
                            </li>
                            <li>
                                <strong>система</strong>: {authInfo.system}
                            </li>
                            <li>
                                <strong>браузер</strong>: {authInfo.browser}
                            </li>
                        </ul>
                        {/* <p>
                            {i18n('ProfileSecurity.notme.auth_text')
                                .replace('%date', authInfo.date)
                                .replace('%time', authInfo.time)
                                .replace('%place', authInfo.place)
                                .replace('%system', authInfo.system)}
                        </p> */}
                    </div>
                </div>
                <div className={b('footer')}>
                    <Button
                        dataT='change-password'
                        size='l'
                        view='clear'
                        type='button'
                        onClick={this.proceedToFinalScreen}
                    >
                        {i18n('ProfileSecurity.notme.ok_btn')}
                    </Button>
                    <Button
                        dataT='next-screen'
                        size='l'
                        view='action'
                        type='button'
                        onClick={this.proceedToChangePassword}
                    >
                        {i18n('Profile.security.check.level')}
                    </Button>
                </div>
            </main>
        );
    }
}

AuthInfo.propTypes = {
    setNextStep: PropTypes.func.isRequired,
    authInfo: PropTypes.shape({
        date: PropTypes.string,
        time: PropTypes.string,
        place: PropTypes.string,
        system: PropTypes.string,
        browser: PropTypes.string
    })
};
