import {connect} from 'react-redux';
import {AuthInfo} from './AuthInfo';
import {setNextStep} from '@blocks/Security/actions';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}} = state;
    const {authInfo = {}} = securityInfo;

    return {
        authInfo
    };
};

const mapDispatchToProps = {
    setNextStep
};

const ConnectedAuthInfo = connect(mapStateToProps, mapDispatchToProps)(AuthInfo);

export {ConnectedAuthInfo as AuthInfo};
