import React from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Header} from '@blocks/authv2/components/Layout/Header';
import Form from '@blocks/authv2/components/Form/Form';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';

import './PushAuth.styl';

const b = cn('PushAuth');

import {changeCodeValue} from './actions';

class PushAuth extends React.Component {
    ref = React.createRef();

    componentDidMount() {
        this.ref && this.ref.current && this.ref.current.focus();
    }

    _handlePushCodeChange = (value) => {
        const {changeCodeValue} = this.props;

        changeCodeValue(value);
    };

    render() {
        const {pushAuth} = this.props;
        const {codeValue} = pushAuth;

        return (
            <div className={b('flexWrapper')}>
                <div className={b('content')}>
                    <div className={b('auth')}>
                        <div className={b('authContent')}>
                            <a data-t='closer' href='#' className='PreviousStepButton' />

                            <Header />

                            <h1 className={b('title')}>{i18n('Frontend.auth.push-auth-title')}</h1>

                            <Form>
                                <Field
                                    value={codeValue}
                                    view='big-input'
                                    size='l'
                                    label={i18n('Frontend.auth.push-auth-label')}
                                    onChange={this._handlePushCodeChange}
                                    ref={this.ref}
                                    options={{inputMode: 'numeric'}}
                                />

                                <div data-t='push_code_submit' className={b('button')}>
                                    <Button
                                        type='submit'
                                        text={i18n('Frontend.send')}
                                        view='action'
                                        size='l'
                                        width='max'
                                        onClick={this._handleSubmit}
                                    />
                                </div>
                            </Form>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}

const mapStateToProps = (state = {}) => {
    const {
        pushAuth = {},
        common: {isWebView},
        am = {}
    } = state;

    return {
        pushAuth,
        am,
        isWebView
    };
};

const mapDispatchToProps = {
    changeCodeValue
};

PushAuth.propTypes = {
    pushAuth: PropTypes.object,
    changeCodeValue: PropTypes.func.isRequired,
    am: PropTypes.object,
    isWebView: PropTypes.bool
};

const connectedPushAuth = connect(mapStateToProps, mapDispatchToProps)(PushAuth);

export {connectedPushAuth as PushAuth};
