import {combineReducers} from 'redux';
import {PUSH_AUTH_CODE_CHANGE} from './actions';
import header from '@blocks/morda/components/header/reducers';
import common from '@blocks/common/reducers';
import am from '@blocks/authv2/reducers/am';

const initialState = {
    codeValue: ''
};
const stub = (state = {}) => state;
const rootReducer = combineReducers({
    header,
    common,
    am,
    person: stub,
    access: stub,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    tracks: stub,
    pushAuth
});

export default rootReducer;

export function pushAuth(state = initialState, action = {}) {
    switch (action.type) {
        case PUSH_AUTH_CODE_CHANGE: {
            return {
                ...state,
                codeValue: action.value
            };
        }
        default:
            return state;
    }
}
