import './Accounts.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {AccountsListItem} from '@components/AccountsListItem';
import {closeBalloon} from '@blocks/SignUp/modes/RegistrationWithSuggestToRestoreByPhone/yabroApi';
import metrika from '@blocks/metrics';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';
import {isRestoreProcess, isRegisterProcess} from '@blocks/UserEntryFlow/utils';
import {SCENARIO_TYPE_REGISTRATION} from '@blocks/UserEntryFlow/processes';

const b = cn('Accounts');

class Accounts extends React.PureComponent {
    componentDidMount() {
        const {accounts = []} = this.props;

        if (accounts.length) {
            metrika.send('Показ экрана саджеста аккаунтов');
            return;
        }

        metrika.send('Показ экрана нулевого саджеста');
    }

    onAccountClick = async ({event, account = {}}) => {
        const {place, switchToLogin, trackId, isKeyEnabled2FA, authEnableKey2FA} = this.props;
        const {
            login,
            uid,
            allowed_auth_flows: allowedAuthFlows = [],
            primary_alias_type: accountTypeAlias = ''
        } = account;
        const isInstantAuthAvailable = allowedAuthFlows.includes('instant');
        const isBrowserReg = place === MODE_BROWSER;

        if (isKeyEnabled2FA) {
            await authEnableKey2FA();
        }

        if (isInstantAuthAvailable && !isBrowserReg) {
            event.preventDefault();
            metrika.send('Саджест аккаунтов - выбор аккаунта с признаком, что можно авторизовать сразу');
            return this.onInstantAllowedAccountAuth(uid, accountTypeAlias);
        }

        if (isBrowserReg) {
            metrika.send('Саджест аккаунтов - закрыли балун в Я.Браузере по нажатию на аккаунт');
            closeBalloon();
        } else {
            event.preventDefault();
            metrika.send('Саджест аккаунтов - переход к окну входа для выбранного из списка аккаунта');
            switchToLogin(login, undefined, trackId);
        }
    };

    onInstantAllowedAccountAuth = (uid, accountTypeAlias) => {
        const {neoPhonishAuth, trackId, lastname, firstname} = this.props;

        neoPhonishAuth({trackId, uid, lastname, firstname, accountTypeAlias});
    };

    onContinueClick = () => {
        const {onContinue, checkFioStepIsRequired, phone} = this.props;

        if (onContinue) {
            // узнаем у сквоттера окончательно, вдруг нам не нужно ФИ при регистрации
            checkFioStepIsRequired(phone, SCENARIO_TYPE_REGISTRATION);

            metrika.send('Выбор регистрация нового аккаунта');
            onContinue();
        }
    };

    getTitleSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'l';
        }
    };

    returnToAuth = () => {
        const {restartUserEntryProcess, switchToModeAddingAccount, setupMode, updateLoginValue} = this.props;

        restartUserEntryProcess();
        setupMode('');
        updateLoginValue('');
        switchToModeAddingAccount();
        metrika.send('Переход на страницу авторизации');
    };

    onRestartRestoreClick = () => {
        const {restartUserEntryProcess} = this.props;

        metrika.send('Повторный поиск аккаунтов с другими данными');
        restartUserEntryProcess();
    };

    maybeRenderRestartRestoreButton = () => {
        const {process} = this.props;

        if (!isRestoreProcess(process)) {
            return null;
        }

        return (
            <AccountsListItem
                isButton={true}
                onClick={this.onRestartRestoreClick}
                text={i18n('_AUTH_.restart.restorelogin')}
                testKey={'accounts:restart'}
            />
        );
    };

    maybeRenderAddButton = () => {
        const {accounts = []} = this.props;

        if (accounts.length) {
            return (
                <div className={b('addButton', {isNewSuggest: true})}>
                    <AccountsListItem
                        isButton={true}
                        onClick={this.onContinueClick}
                        text={i18n('_AUTH_.registration.btn.createnew')}
                        testKey={'accounts:register'}
                    />
                </div>
            );
        }

        return (
            <Button
                text={i18n('_AUTH_.step.accounts.createID')}
                onClick={this.onContinueClick}
                type='button'
                dataT='accounts: createIDBtn'
                width='max'
                size='l'
            />
        );
    };

    getTitle = () => {
        const {
            accounts = [],
            isDoregishFlowAvailable,
            process,
            isRegisterNeophonishProcess,
            isRegAfterAuthStart
        } = this.props;

        if (isDoregishFlowAvailable && !accounts.length && isRegisterProcess(process)) {
            return i18n('_AUTH_.step.accounts.empty.reg');
        }

        if (!accounts.length && isRegisterNeophonishProcess && isRegAfterAuthStart) {
            return i18n('_AUTH_.step.accounts.empty.reg.neophonish');
        }

        if (accounts.length) {
            return i18n('_AUTH_.step.accounts.title');
        }

        return i18n('_AUTH_.step.accounts.empty.title');
    };

    getDescription = () => {
        const {
            accounts = [],
            isDoregishFlowAvailable,
            process,
            isRegisterNeophonishProcess,
            isRegAfterAuthStart
        } = this.props;

        if (accounts.length) {
            return i18n('_AUTH_.step.accounts.description');
        }

        if (
            (isDoregishFlowAvailable && isRegisterProcess(process)) ||
            (isRegisterNeophonishProcess && isRegAfterAuthStart)
        ) {
            return null;
        }

        return i18n('_AUTH_.step.accounts.empty.description');
    };

    maybeRenderAuthButton = () => {
        const {accounts = []} = this.props;

        if (!accounts.length) {
            return (
                <Button
                    text={i18n('_AUTH_.step.accounts.gotoAuth')}
                    onClick={this.returnToAuth}
                    view='pseudo'
                    type='button'
                    dataT='accounts: backToAuth'
                    width='max'
                    size='l'
                />
            );
        }

        return null;
    };

    render() {
        const {accounts = []} = this.props;
        const elemId = 'passp:Accounts';

        return (
            <div className={b()}>
                <Title size={this.getTitleSize()}>{this.getTitle()}</Title>
                <Description dataT={elemId} id={elemId}>
                    {this.getDescription()}
                </Description>
                <div className={b('body')}>
                    <div className={b('list')}>
                        {accounts.map((account) => (
                            <AccountsListItem
                                account={account}
                                onClick={this.onAccountClick}
                                key={`account-${account.uid}`}
                                testKey={`accounts:item-${account.uid}`}
                            />
                        ))}

                        {this.maybeRenderRestartRestoreButton()}
                        {this.maybeRenderAddButton()}
                        {this.maybeRenderAuthButton()}
                    </div>
                </div>
            </div>
        );
    }
}

Accounts.propTypes = {
    accounts: PropTypes.arrayOf(
        PropTypes.shape({
            default_avatar: PropTypes.string.isRequired,
            login: PropTypes.string.isRequired,
            avatar_url: PropTypes.string
        })
    ),
    authEnableKey2FA: PropTypes.func,
    onContinue: PropTypes.func.isRequired,
    switchToLogin: PropTypes.func,
    place: PropTypes.string,
    process: PropTypes.string,
    neoPhonishAuth: PropTypes.func.isRequired,
    restartUserEntryProcess: PropTypes.func,
    switchToModeAddingAccount: PropTypes.func.isRequired,
    setupMode: PropTypes.func.isRequired,
    updateLoginValue: PropTypes.func.isRequired,
    checkFioStepIsRequired: PropTypes.func.isRequired,
    trackId: PropTypes.string,
    lastname: PropTypes.string,
    firstname: PropTypes.string,
    useNewSuggestByPhone: PropTypes.bool,
    allowedRegFlow: PropTypes.string,
    isDoregishFlowAvailable: PropTypes.bool,
    isRegisterNeophonishProcess: PropTypes.bool,
    isRegAfterAuthStart: PropTypes.bool,
    isKeyEnabled2FA: PropTypes.bool,
    phone: PropTypes.string
};

export {Accounts};
