import {connect} from 'react-redux';
import {Accounts} from './Accounts.jsx';
import {checkIsDoregishFlowProcess, getProcessName, isRegisterNeophonishProcess} from '@blocks/UserEntryFlow/utils';
import {restartUserEntryProcess} from '@blocks/UserEntryFlow/actions';
import {switchToLogin} from '@blocks/authv2/actions/multiStepAuthStart';
import switchToModeAddingAccount from '@blocks/authv2/actions/switchToModeAddingAccount';
import {neoPhonishAuth} from '@blocks/actions/neoPhonish';
import {getFormValues, hasExp} from '@blocks/selectors';
import {setupMode, updateLoginValue} from '@blocks/authv2/actions';
import {checkFioStepIsRequired} from '@blocks/UserEntryFlow/logic';

const sortByPlus = (accounts) => accounts.sort((acc1, acc2) => (acc2.has_plus ? 1 : 0) - (acc1.has_plus ? 1 : 0));

const mapStateToProps = (state = {}) => {
    const {accountsSuggest = {}, userEntryFlow: {allowedRegFlow, isRegAfterAuthStart = false} = {}} = state;
    const {accounts = []} = accountsSuggest;
    const process = getProcessName(state);
    const values = getFormValues(state);
    const {firstname, lastname, phone} = values;

    return {
        accounts: sortByPlus(accounts),
        process,
        firstname,
        lastname,
        phone,
        useNewSuggestByPhone: hasExp(state, 'use-new-suggest-by-phone'),
        allowedRegFlow,
        isDoregishFlowAvailable: checkIsDoregishFlowProcess(state),
        isRegisterNeophonishProcess: isRegisterNeophonishProcess(process),
        isRegAfterAuthStart
    };
};

const mapDispatchToProps = {
    neoPhonishAuth,
    restartUserEntryProcess,
    switchToLogin,
    setupMode,
    updateLoginValue,
    switchToModeAddingAccount,
    checkFioStepIsRequired
};

const ConnectedAccounts = connect(mapStateToProps, mapDispatchToProps)(Accounts);

export {ConnectedAccounts as Accounts};
