import './Captcha.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {CaptchaField} from '@components/CaptchaField';
import metrika from '@blocks/metrics';
import {FIELDS_NAMES} from '@components/Field';

const b = cn('CaptchaScreen');

class Captcha extends React.PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана ввода капчи');
    }

    componentWillUnmount() {
        const {updateValues} = this.props;

        updateValues({field: FIELDS_NAMES.CAPTCHA, value: ''});
    }

    checkCaptcha = (event) => {
        const {checkCaptcha, onConfirmAction, onConfirmActionArguments, onConfirmCallback} = this.props;

        event.preventDefault();
        checkCaptcha({action: onConfirmAction, actionArguments: onConfirmActionArguments, callback: onConfirmCallback});
    };

    render() {
        const {loading, buttonView} = this.props;

        return (
            <form onSubmit={this.checkCaptcha} className={b()}>
                <div className={b('head')}>
                    <Title>{i18n('_AUTH_.enter_captcha_label')}</Title>
                </div>

                <div className={b('body')}>
                    <CaptchaField isCaptchaRequired={true} isShowCaptcha={true} fieldView='big-input' view='column' />
                </div>

                <div className={b('controls')}>
                    <Button
                        text={i18n('_AUTH_.next')}
                        onClick={this.checkCaptcha}
                        width='max'
                        size='l'
                        type='submit'
                        view={buttonView}
                        disabled={loading}
                    />
                </div>
            </form>
        );
    }
}

Captcha.propTypes = {
    onConfirmAction: PropTypes.func,
    onConfirmActionArguments: PropTypes.array,
    onConfirmCallback: PropTypes.func,
    checkCaptcha: PropTypes.func.isRequired,
    updateValues: PropTypes.func.isRequired,
    loading: PropTypes.bool,
    buttonView: PropTypes.string
};

export {Captcha};
