import {connect} from 'react-redux';
import {Captcha} from './Captcha.jsx';
import checkCaptcha from '@blocks/authv2/actions/checkCaptcha';
import {updateValues} from '@blocks/actions/form';

const mapStateToProps = (state) => {
    const {auth = {}, customs = {}} = state;
    const {loading} = auth;

    return {
        loading,
        buttonView: customs.buttonView
    };
};

const mapDispatchToProps = {
    checkCaptcha,
    updateValues
};

const ConnectedCaptcha = connect(mapStateToProps, mapDispatchToProps)(Captcha);

export {ConnectedCaptcha as Captcha};
