import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Password} from '@components/Password';
import {PasswordConfirm} from '@components/PasswordConfirm';
import {CaptchaField} from '@components/CaptchaField';
import {Checkbox} from '@components/Checkbox';
import {cn} from '@bem-react/classname';

import './ChangePassword.styl';

const b = cn('ChangePassword');

export class ChangePassword extends PureComponent {
    componentDidMount() {
        this.props.changePasswordSubmit();
    }

    handleGlobalLogout = () => {
        const {isGlobalLogoutChecked, toggleGlobalLogout} = this.props;

        toggleGlobalLogout(!isGlobalLogoutChecked);
    };

    render() {
        const {login, revokers, isGlobalLogoutChecked} = this.props;

        return (
            <div className={b('Form')}>
                <input
                    className='g-hidden'
                    type='text'
                    name='login'
                    id='login'
                    readOnly={true}
                    autoComplete='username'
                    value={login}
                />
                <Password
                    ref={this.ref}
                    name='current_password'
                    label={i18n('_AUTH_.field_password_current')}
                    hasToggler={false}
                    size='l'
                    options={{autoComplete: 'current-password'}}
                />
                <Password
                    label={i18n('ProfileSecurity.security.new_pwd_label')}
                    shouldValidate={true}
                    size='l'
                    options={{autoComplete: 'new-password'}}
                />
                <PasswordConfirm
                    shouldValidateOnUpdates={false}
                    label={i18n('ProfileSecurity.security.new_pwd_confirm_label')}
                    size='l'
                    options={{autoComplete: 'new-password'}}
                />
                <CaptchaField />
                <div className={b('checkbox')}>
                    <Checkbox
                        size='s'
                        disabled={!revokers.allow_select}
                        checked={isGlobalLogoutChecked}
                        onChange={this.handleGlobalLogout}
                        label={i18n('Frontend.profile.access.2fa-disable.logout')}
                    />
                </div>
            </div>
        );
    }
}

ChangePassword.propTypes = {
    login: PropTypes.string,
    isMobile: PropTypes.bool,
    revokers: PropTypes.object,
    isGlobalLogoutChecked: PropTypes.bool,
    changePasswordSubmit: PropTypes.func.isRequired,
    toggleGlobalLogout: PropTypes.func.isRequired
};
