import {connect} from 'react-redux';
import {ChangePassword} from './ChangePassword.jsx';
import {isMobile} from '@blocks/selectors';
import {changePasswordSubmit, toggleGlobalLogout} from '@blocks/actions/changePassword';

const mapStateToProps = (state = {}) => {
    const {header = {}, changePassword} = state;
    const {defaultAccount = {}} = header;
    const {revokers = {}, isGlobalLogoutChecked} = changePassword;

    return {
        login: defaultAccount.login,
        isMobile: isMobile(state),
        revokers,
        isGlobalLogoutChecked
    };
};

const mapDispatchToProps = {
    changePasswordSubmit,
    toggleGlobalLogout
};

const ConnectedChangePassword = connect(mapStateToProps, mapDispatchToProps)(ChangePassword);

export {ConnectedChangePassword as ChangePassword};
