import {connect} from 'react-redux';
import {ConfigureEmail} from './ConfigureEmail.jsx';
import {isMobile, getFormErrors} from '@blocks/selectors';
import {
    sendConfirmationCode,
    checkConfirmationCode,
    markEmailDeleted,
    unmarkEmailDeleted
} from '@blocks/actions/editEmails';

const mapStateToProps = (state = {}) => {
    const {editEmails = {}, isLoading, header = {}} = state;
    const {defaultAccount = {}} = header;
    const errors = getFormErrors(state) || {};
    const {hasCodeSent, emailsToDelete} = editEmails;
    const {login, havePassword, is_liteUser} = defaultAccount;

    return {
        hasCodeSent,
        emailsToDelete,
        emailFieldError: errors.email,
        codeFieldError: errors.email_code,
        hasPassword: havePassword,
        isLiteUser: is_liteUser,
        login,
        isMobile: isMobile(state),
        isLoading
    };
};

const mapDispatchToProps = {
    sendConfirmationCode,
    markEmailDeleted,
    unmarkEmailDeleted,
    checkConfirmationCode
};

const ConnectedConfigureEmail = connect(mapStateToProps, mapDispatchToProps)(ConfigureEmail);

export {ConnectedConfigureEmail as ConfigureEmail};
