import React from 'react';
import {PropTypes} from 'prop-types';
import {classNames} from '@blocks/utils';
import {Button} from '@components/Button';
import {Password} from '@components/Password';
import {Title} from '@components/Title';
import {FIELDS_NAMES} from '@components/Field/names';

const b = classNames('CurrentPassword');

export class CurrentPassword extends React.PureComponent {
    static propTypes = {
        login: PropTypes.string.isRequired,
        buttonView: PropTypes.string,
        isLoading: PropTypes.bool.isRequired,
        onConfirm: PropTypes.func.isRequired
    };

    render() {
        const {login, buttonView, isLoading, onConfirm} = this.props;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title>{i18n('_AUTH_.field_password_current')}</Title>
                </div>
                <div className={b('body')}>
                    <input
                        type='hidden'
                        name={FIELDS_NAMES.LOGIN}
                        id='login'
                        readOnly={true}
                        autoComplete='username'
                        value={login}
                    />
                    <Password hideLabel={true} shouldValidate={true} view='big-input' size='l' />
                </div>
                <div className={b('controls')}>
                    <Button
                        onClick={onConfirm}
                        text={i18n('_AUTH_.next')}
                        width='max'
                        size='l'
                        disabled={isLoading}
                        type='submit'
                        view={buttonView}
                    />
                </div>
            </div>
        );
    }
}
