import React from 'react';
import {cn} from '@bem-react/classname';
import PropTypes from 'prop-types';

import './Button.styl';

const b = cn('Button');

export const Button = ({children, href, blank, dependent, className}) => {
    const Component = href ? 'a' : 'button';
    const additionalProps = href
        ? {
              href,
              target: blank && '_blank'
          }
        : {};

    return (
        <Component className={b({dependent}, [className])} {...additionalProps}>
            {children}
        </Component>
    );
};

Button.propTypes = {
    blank: PropTypes.bool,
    dependent: PropTypes.bool,
    href: PropTypes.string,
    className: PropTypes.string,
    children: PropTypes.node.isRequired
};
