import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './Intro.styl';

const b = cn('Intro');

const ICONS = [
    'bookmark_blue',
    'bookmark_red',
    'shuriken_yellow',
    'shuriken_yellow_3',
    'star_red',
    'star_turq',
    'laptop_blue',
    'phone_turq',
    'shuriken_yellow_2',
    'tablet_red',
    'repeat'
];

export const Intro = ({active}) => {
    return (
        <div className={b()}>
            <div className={b('icons')}>
                {ICONS.map((icon) => (
                    <div
                        key={icon}
                        className={b('icon', {
                            active,
                            [icon]: true
                        })}
                    />
                ))}
            </div>
        </div>
    );
};

Intro.propTypes = {
    active: PropTypes.bool
};
