import React, {memo} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {useLogic} from './useLogic';
import {Spin} from '@components/Spin';

import './Qr.styl';

const b = cn('Qr');

export const Qr = memo(({active, onError, onTimeout}) => {
    const {isLoading, magicTrack} = useLogic({active, onTimeout, onError});

    return (
        <div className={b()}>
            <div className={b('wrapper')}>
                <div className={b('inner')}>
                    {!isLoading ? (
                        <>
                            <div className={b('img')}>
                                <img alt='' src={`/auth/magic/code/?track_id=${magicTrack}`} />
                            </div>
                            <div className={b('logo')} />
                        </>
                    ) : (
                        <div className={b('content')}>
                            <div className={b('spin')}>
                                <Spin progress={true} size='m' />
                            </div>
                        </div>
                    )}
                </div>
            </div>
        </div>
    );
});

Qr.propTypes = {
    active: PropTypes.bool.isRequired,
    onError: PropTypes.func.isRequired,
    onTimeout: PropTypes.func.isRequired
};
