import {DEEPSYNC_SET_ERROR, DEEPSYNC_SET_LOADING, DEEPSYNC_UPDATE_MAGIC_TOKENS} from './constants';

const reducers = {
    [DEEPSYNC_SET_LOADING]: (state, {isLoading}) => ({...state, isLoading}),
    [DEEPSYNC_SET_ERROR]: (state, {error}) => ({...state, error}),
    [DEEPSYNC_UPDATE_MAGIC_TOKENS]: (state, {magicTrack, magicCSRF}) => ({
        ...state,
        magicCSRF,
        magicTrack,
        isLoading: false
    })
};

export default (state = {}, action) => (reducers[action.type] ? reducers[action.type](state, action) : state);
