import api from '../../api';
import {setLoading, setError, updateMagicTokens} from './actions';

export const magicSubmit = () => (dispatch, getState) => {
    const {
        common: {profile_url: profileUrl, retpath, fretpath, clean, origin}
    } = getState();

    dispatch(setLoading(true));

    return api
        .request('auth/password/submit', {
            retpath: retpath || profileUrl,
            fretpath,
            clean,
            origin
        })
        .done(({track_id: trackId, csrf_token: magicCSRF}) => dispatch(updateMagicTokens(trackId, magicCSRF)))
        .fail(() => dispatch(setError('global')))
        .always(() => dispatch(setLoading(false)));
};
