import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import {DeleteDataButtonIconInfo} from './Info';
import {DeleteDataButtonIconStars} from './Stars';
import {DeleteDataButtonIconShield} from './Shield';
import {DeleteDataButtonIconFolder} from './Folder';
import {DeleteDataButtonIconArrowDown} from './ArrowDown';

import './Button.styl';

const b = cn('DeleteDataButton');
const ICONS = {
    info: DeleteDataButtonIconInfo,
    stars: DeleteDataButtonIconStars,
    shield: DeleteDataButtonIconShield,
    folder: DeleteDataButtonIconFolder,
    arrowDown: DeleteDataButtonIconArrowDown
};
const ICON_PROPTYPE = PropTypes.oneOf(Object.keys(ICONS));

export const DeleteDataButton = ({icon, iconRight, children, className, onClick, center, fullWidth}) => {
    const IconComponent = (icon || iconRight) && ICONS[icon || iconRight];

    return (
        <button className={b({center, fullWidth}, [className])} onClick={onClick}>
            {icon && IconComponent && (
                <span className={b('icon', {[icon]: true})}>
                    <IconComponent />
                </span>
            )}
            {children && <span className={b('text')}>{children}</span>}
            {iconRight && IconComponent && (
                <span className={b('icon', {right: true, [iconRight]: true})}>
                    <IconComponent />
                </span>
            )}
        </button>
    );
};

DeleteDataButton.propTypes = {
    className: PropTypes.string,
    children: PropTypes.node,
    icon: ICON_PROPTYPE,
    iconRight: ICON_PROPTYPE,
    center: PropTypes.bool,
    fullWidth: PropTypes.bool,
    onClick: PropTypes.func
};
