import React, {useState} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Spin} from '@components/Spin';
import {DeleteDataServiceLogo} from '../ServiceLogo';

import './Card.styl';

const b = cn('DeleteDataCard');

export const DeleteDataCard = ({
    title,
    noData,
    loading,
    hasError,
    children,
    groupName,
    description,
    serviceName,
    hasInProgress
}) => {
    const [expanded, setExpanded] = useState(false);
    const expandable = Boolean(children);

    return (
        <div aria-expanded={expanded} className={b({expanded})}>
            <div
                role={expandable ? 'button' : undefined}
                className={b('main', {expandable, collapsed: !expanded})}
                onClick={expandable ? () => setExpanded((e) => !e) : undefined}
            >
                <div className={b('logoWrapper')}>
                    <DeleteDataServiceLogo className={b('logo')} id={serviceName || groupName} />
                </div>
                <div className={b('content')}>
                    <div className={b('title')}>{title}</div>
                    {hasError ? (
                        <div className={b('desc')}>{i18n('DeleteData.deletion.unable')}</div>
                    ) : (
                        <>
                            {(description || noData || hasInProgress) && (
                                <div className={b('desc', {nd: noData})}>
                                    {noData && i18n('DeleteData.deletion.no-data')}
                                    {!noData && hasInProgress && i18n('DeleteData.service.deleting')}
                                    {!noData && !hasInProgress && description}
                                </div>
                            )}
                        </>
                    )}
                </div>
                {loading && !expanded && (
                    <div className={b('deleting')}>
                        <Spin progress={true} size='xxs' />
                    </div>
                )}
                {!loading && hasError && <div className={b('errorSign')} />}
            </div>
            <div className={b('items', {expanded})}>{children}</div>
        </div>
    );
};

DeleteDataCard.displayName = 'DeleteDataCard';

DeleteDataCard.propTypes = {
    children: PropTypes.node,
    loading: PropTypes.bool,
    serviceName: PropTypes.string,
    groupName: PropTypes.string,
    hasError: PropTypes.bool,
    hasInProgress: PropTypes.bool,
    noData: PropTypes.bool,
    title: PropTypes.string,
    description: PropTypes.string
};
