import React, {useContext} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Drawer} from '@components/Drawer';
import Modal from '@components/Wrappers/Modal';
import {Context} from '../ModalContext';

import './Drawer.styl';

const b = cn('DeleteDataDrawer');

const stop = (e) => e.stopPropagation();

export const DeleteDataDrawer = ({title, modalMaxWidth, visible, children, scope, onClose}) => {
    const isModal = useContext(Context);
    const Component = isModal ? Modal : Drawer;
    const componentProps = {
        visible,
        onClose,
        onClick: stop,
        ...(isModal ? {} : {scope, view: 'default'})
    };

    return (
        <Component {...componentProps}>
            <div
                className={b({modal: isModal, drawer: !isModal})}
                style={isModal && modalMaxWidth ? {maxWidth: modalMaxWidth} : undefined}
            >
                {title && <div className={b('title')}>{title}</div>}
                <div className={b('content')}>{children}</div>
            </div>
        </Component>
    );
};

DeleteDataDrawer.propTypes = {
    modalMaxWidth: PropTypes.number,
    visible: PropTypes.bool,
    onClose: PropTypes.func,
    title: PropTypes.string,
    children: PropTypes.node,
    scope: PropTypes.object
};
