import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';
import {getData} from '../thunks';

import './Error.styl';

const b = cn('DeleteDataError');

export const DeleteDataError = () => {
    const dispatch = useDispatch();
    const onRetry = useCallback(() => {
        dispatch(getData());
    }, [dispatch]);

    return (
        <div className={b()}>
            <Button view='action' size='l' dataT='reload' onClick={onRetry} className={b('button')}>
                {i18n('DeleteData.try-again')}
            </Button>
        </div>
    );
};
