import React, {memo} from 'react';
import {cn} from '@bem-react/classname';
import {useSelector} from 'react-redux';
import {ITEMS} from './data';
import {DeleteDataFAQItem} from './Item';

import './FAQ.styl';

const b = cn('DeleteDataFAQ');

export const DeleteDataFAQ = memo(() => {
    const tld = useSelector((state) => state.settings.tld);

    return (
        <div className={b()}>
            {ITEMS.map((item) => (
                <DeleteDataFAQItem
                    key={item.question}
                    question={item.question}
                    answer={item.answer.replace('%tld%', tld)}
                    className={b('item')}
                />
            ))}
        </div>
    );
});

DeleteDataFAQ.displayName = 'DeleteDataFAQ';
